% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R
\name{brk_manual}
\alias{brk_manual}
\title{Create a \code{breaks} object manually}
\usage{
brk_manual(breaks, left_vec)
}
\arguments{
\item{breaks}{A vector, which must be sorted.}

\item{left_vec}{A logical vector, the same length as \code{breaks}.
Specifies whether each break is left-closed or right-closed.}
}
\value{
A (function which returns an) object of class \code{breaks}.
}
\description{
Create a \code{breaks} object manually
}
\details{
All breaks must be closed on exactly one side, like \verb{..., x) [x, ...}
(left-closed) or \verb{..., x) [x, ...} (right-closed).

For example, if \code{breaks = 1:3} and \code{left = c(TRUE, FALSE, TRUE)}, then the
resulting intervals are \preformatted{
T        F       T
[ 1,  2 ] ( 2, 3 )
}

Singleton breaks are created by repeating a number in \code{breaks}. Singletons
must be closed on both sides, so if there is a repeated number
at indices \code{i}, \code{i+1}, \code{left[i]} \emph{must} be \code{TRUE} and \code{left[i+1]} must be
\code{FALSE}.
}
\examples{
lbrks <- brk_manual(1:3, rep(TRUE, 3))
chop(1:3, lbrks, extend = FALSE)

rbrks <- brk_manual(1:3, rep(FALSE, 3))
chop(1:3, rbrks, extend = FALSE)

brks_singleton <- brk_manual(
      c(1,    2,    2,     3),
      c(TRUE, TRUE, FALSE, TRUE))

chop(1:3, brks_singleton, extend = FALSE)

}
