% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_n}
\alias{chop_n}
\alias{brk_n}
\alias{tab_n}
\title{Chop into fixed-sized groups}
\usage{
chop_n(x, n, ..., close_end = TRUE)

brk_n(n)

tab_n(x, n, ..., close_end = TRUE)
}
\arguments{
\item{x}{A vector.}

\item{n}{Integer: number of elements in each interval.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_n()} creates intervals containing a fixed number of elements. One
interval may have fewer elements.
}
\details{
Note that \code{chop_n()} sets \code{close_end = TRUE} by default.

Groups may be larger than \code{n}, if there are too many duplicated elements
in \code{x}. If so, a warning is given.
}
\examples{
chop_n(1:10, 5)

# too many duplicates
x <- rep(1:2, each = 3)
chop_n(x, 2)

tab_n(1:10, 5)

# fewer elements in one group
tab_n(1:10, 4)

}
\seealso{
Other chopping functions: 
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
