% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_worldmap.R
\name{tweet_worldmap}
\alias{tweet_worldmap}
\title{Twitter Data Worldmap Plot.}
\usage{
tweet_worldmap(DataFrame, HT_Topic)
}
\arguments{
\item{DataFrame}{DataFrame of Twitter Data that has been tidy'd and scored.}

\item{HT_Topic}{If using hashtag data select:  "hashtag".  If using topic data select:  "topic".}
}
\value{
A ggplot plot.
}
\description{
Displays the location of a Tweet across the globe by hashtag or topic.
}
\examples{
\donttest{
library(saotd)
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data, 
                           HT_Topic = "hashtag") 
ht_map <- tweet_worldmap(DataFrameTidyScores = score_data,
                         HT_Topic = "hashtag")
ht_map
               
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data, 
                           HT_Topic = "topic") 
topic_map <- tweet_worldmap(DataFrameTidyScores = score_data,
                      HT_Topic = "topic") 
topic_map                    
}
}
