% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_time.R
\name{tweet_time}
\alias{tweet_time}
\title{Twitter Data Timeseries Plot.}
\usage{
tweet_time(DataFrameTidyScores, HT_Topic)
}
\arguments{
\item{DataFrameTidyScores}{DataFrame of Twitter Data that has been tidy'd 
and scored.}

\item{HT_Topic}{If using hashtag data select:  "hashtag".  If using topic 
data select:  "topic".}
}
\value{
A ggplot plot.
}
\description{
Displays the Twitter data sentiment scores through time.  The 
  sentiment scores by hashtag or topic are summed per day and plotted to 
  show the change in sentiment through time.
}
\examples{
\dontrun{
library(saotd)
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data,
                           HT_Topic = "hashtag")
ht_time <- tweet_time(DataFrameTidyScores = score_data,
                      HT_Topic = "hashtag")
ht_time

data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data,
                           HT_Topic = "topic")
topic_time <- tweet_time(DataFrameTidyScores = score_data,
                         HT_Topic = "topic")
topic_time                    
}
}
