% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_dplyr.R
\name{sfn_mutate}
\alias{sfn_mutate}
\title{Mutate variables by function}
\usage{
sfn_mutate(sfn_data, ..., solar = FALSE)
}
\arguments{
\item{sfn_data}{\code{sfn_data} or \code{sfn_data_multi} object to subset}

\item{...}{Name-value pairs of expressions to pass to the
\code{\link[dplyr]{mutate}} function.}

\item{solar}{Logical indicating if solar timestamp must used to subset}
}
\value{
For \code{sfn_data} objects, a mutated \code{sfn_data}. For
  \code{sfn_data_multi} another \code{sfn_data_multi} with the sites mutated
}
\description{
Port of \code{\link[dplyr]{mutate}} for \code{sfn_data} and
\code{sfn_data_multi} objects
}
\details{
`sfn_mutate` function will maintain the same number of rows before and after
the modification, so it is well suited to modify variables without creating
TIMESTAMP gaps (i.e. to change variable units). For mutating groups of
variables at the same time see \code{\link{sfn_mutate_at}}.
}
\section{Sapflow and environmental variables}{

`sfn_mutate` internally joins the sapflow and environmental datasets by the
TIMESTAMP, so it is possible to mutate variables conditionally between
sapflow and environmental measures (i.e. mutate sapflow when wind is high or
radiation is zero). Due to this, at the moment any new variable is dropped
when building the final results, so this is ONLY intended to mutate
existing variables without changing the names.
}

\examples{
library(dplyr)
library(lubridate)

# data
data('ARG_TRE', package = 'sapfluxnetr')

# transform to NAs any wind value above 25
ws_threshold <- 25
sfn_mutate(ARG_TRE, ws = if_else(ws > 25, NA_real_, ws))

## multi
data(ARG_MAZ, package = 'sapfluxnetr')
data(AUS_CAN_ST2_MIX, package = 'sapfluxnetr')
multi_sfn <- sfn_data_multi(ARG_TRE, ARG_MAZ, AUS_CAN_ST2_MIX)

multi_sfn_mutated <- sfn_mutate(
  multi_sfn, ws = if_else(ws > 25, NA_real_, ws)
)

multi_sfn_mutated[['ARG_TRE']]

}
