% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{omitted_recoder_df}
\alias{omitted_recoder_df}
\title{Recode Missing By Type of Missingness}
\usage{
omitted_recoder_df(
  df,
  accept_vector = FALSE,
  skipped = 0L,
  not_administered = NA_integer_,
  all_missing = NA_integer_
)
}
\arguments{
\item{df}{Data frame, or vector. Must be a dataframe, not a matrix, in this
function. Only include item variables.}

\item{accept_vector}{Handles vectors if accept_vector=TRUE. Set to false to
avoid accidents when using function per block and there is just one item in
the block.}

\item{skipped}{What to replace skipped values with}

\item{not_administered}{What to replace not administered values with.}

\item{all_missing}{What to replace values in rows with all missing with.}
}
\value{
A data.frame (or vector, if input is vector and accept_vector=TRUE)
with recoded cells.
}
\description{
Useful for item difficulty estimation according to Mislevy's recommendation.
Also allowing for escaping rows with all missingess (typically
not administered).
}
\examples{
# Original data
input <- stats::setNames(as.data.frame(matrix(c(
	1,0,1,0,1, # All present
	NA,0,1,0,1, # First missing
	NA,NA,1,0,1, # First two missing
	1,0,NA,0,1, # One in middle missing
	1,NA,NA,NA,1, # All in the middle missing
	1,0,1,0,NA, # Last one missing
	1,0,1,NA,NA, # Last two missing
	1,0,NA,NA,NA, # Last three missing
	NA,NA,NA,NA,NA # All missing
), nrow = 9, byrow = TRUE)), nm=stringi::stri_c(ignore_null=TRUE, "X", 1:5))
# What should be the output for item estimation according to Mislevy
# Skipped=> 0, not_administered=>NA, all_missing=>NA
y_i <-  stats::setNames(as.data.frame(matrix(c(
	1,0,1,0,1, # All present
	0,0,1,0,1, # First missing
	0,0,1,0,1, # First two missing
	1,0,0,0,1, # One in middle missing
	1,0,0,0,1, # All in the middle missing
	1,0,1,0,0, # Last one missing
	1,0,1,0,NA, # Last two missing
	1,0,0,NA,NA, # Last three missing
	NA,NA,NA,NA,NA # All missing
), nrow = 9, byrow = TRUE)), nm=stringi::stri_c(ignore_null=TRUE, "X", 1:5))

# What should be the output for person estimation according to Mislevy
# Skipped=> 0, not_administered=>NA, all_missing=>NA
y_p <- stats::setNames(as.data.frame(matrix(c(
	1,0,1,0,1, # All present
	0,0,1,0,1, # First missing
	0,0,1,0,1, # First two missing
	1,0,0,0,1, # One in middle missing
	1,0,0,0,1, # All in the middle missing
	1,0,1,0,0, # Last one missing
	1,0,1,0,0, # Last two missing
	1,0,0,0,0, # Last three missing
	0,0,0,0,0 # All missing
), nrow = 9, byrow = TRUE)), nm=stringi::stri_c(ignore_null=TRUE, "X", 1:5))
# Recoding for counting skipped, not_administered, all_missing, etc
# Skipped=> 99, not_administered=>999, all_missing=>9999
y_info <- stats::setNames(as.data.frame(matrix(c(
	1,0,1,0,1, # All present
	99,0,1,0,1, # First missing
	99,99,1,0,1, # First two missing
	1,0,99,0,1, # One in middle missing
	1,99,99,99,1, # All in the middle missing
	1,0,1,0,99, # Last one missing
	1,0,1,99,999, # Last two missing
	1,0,99,999,999, # Last three missing
	9999,9999,9999,9999,9999 # All missing
), nrow = 9, byrow = TRUE)), nm=stringi::stri_c(ignore_null=TRUE, "X", 1:5))

y_i2 <- omitted_recoder_df(input) #Mislevy item estimation
y_p2 <- omitted_recoder_df(input, skipped = 0L, #Mislevy person estimation
                           not_administered = 0L, all_missing = 0L)
y_info2 <- omitted_recoder_df(input, skipped = 99,
                              not_administered = 999, all_missing = 9999)
identical(y_i, y_i2)
identical(y_p, y_p2)
identical(y_info, y_info2)
\dontrun{
omitted_recoder_df(input[,4]) # Should fail
}
identical(omitted_recoder_df(input[,4], accept_vector=TRUE),
         c(0,0,0,0,0,0,0,NA,NA))
identical(omitted_recoder_df(input[,4, drop=FALSE]),
          input[,4, drop=FALSE]) # Output should equal input
}
