% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{prepare_safe_render}
\alias{prepare_safe_render}
\title{Convenience function to prepare, copy and render website}
\usage{
prepare_safe_render(
  remote_basepath = "/home/",
  from_folders = NULL,
  from_files = NULL,
  local_basepath,
  site,
  rel_path_base_to_parent_of_user_restricted_folder = "Reports",
  overwrite = FALSE,
  prompt = TRUE
)
}
\arguments{
\item{remote_basepath}{String. FTP servers often have a subdomain path location different from "/home/". Adjust this here.}

\item{from_folders, from_files}{Character vector of folders and files to copy into the site path.}

\item{local_basepath}{String. Path to where your QMD-files are located (the site to be rendered).}

\item{site}{String. Path to where to copy folders and files to setup what Quarto needs to build a project.}

\item{rel_path_base_to_parent_of_user_restricted_folder}{String. Path going from basepath to the folder containing folders to password-protect.}

\item{overwrite}{Flag. Defaults to FALSE to ensure you know what you are doing. If TRUE, will delete all files and folders in site!}

\item{prompt}{Flag. Whether to ask the user if they are certain. Defaults to TRUE.}
}
\value{
local_basepath
}
\description{
Rendering a website on a Sharepoint/OneDrive location can be a pain
due to long filepaths above 260 characters, which causes read errors. This
function simplifies things by copying a site from local_basepath to a site_basepath,
sets up basic access authentication files (either Netlify's _headers file or
regular Apache .htaccess/.htpasswd files), as well as optionally copying
in an existing Netlify _publish.yaml-file.
}
