% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{col_to_binaries}
\alias{col_to_binaries}
\title{Mutate a (factor, character, integer, etc) column into multiple columns,}
\usage{
col_to_binaries(data, col, var_separator = "___", label_separator = " - ")
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{col}{Single column. Tidy-select.}

\item{var_separator}{\emph{Variable separator}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Separator between old variable name and categories.}

\item{label_separator}{\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Separator between old label name and new label part.}
}
\value{
Original data frame with the binary columns attached, containing new labels.
}
\description{
Easily mutate a single column into multiple columns (~dummies+1),
while retaining variable labels and order of the original factor variable.
}
\examples{
col_to_binaries(ex_survey, col = b_3, label_separator = "  -  ")
}
