% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warpWindowSP.R
\name{warpWindowSP}
\alias{warpWindowSP}
\title{Restrict the DTW warping window for snow profiles alignment}
\usage{
warpWindowSP(
  iw,
  jw,
  iheight,
  jheight,
  iddate,
  jddate,
  profile.size,
  profile.height,
  window.size = 0.3,
  ddate.window.size = Inf,
  ...
)
}
\arguments{
\item{iw}{matrix of integers indicating their row number (cf., \code{?row})}

\item{jw}{matrix of integers indicating their column number (cf., \code{?col})}

\item{iheight}{matrix of query height filled into the columns of the matrix}

\item{jheight}{matrix of ref height filled into the rows of the matrix}

\item{iddate}{same as iheight, but containing deposition date information}

\item{jddate}{same as jheight, but containing deposition date information}

\item{profile.size}{number of layers in each of the profiles (scalar)}

\item{profile.height}{snow height of the profiles (scalar)}

\item{window.size}{percentage of profile.size or profile.height defining the size of the warping window
(i.e., the most restrictive of the two will be applied)}

\item{ddate.window.size}{number of days that exclude layers from the warping window if their deposition dates
differ by more than these days}

\item{...}{unused---but important to be able to provide other warping functions to \link{distMatSP}}
}
\description{
Given a \emph{quadratic} matrix, this function sets all elements of the matrix that are outside the so-called warping
window to \code{NA}. The warping window is a slanted band of constant width around the main diagonal
(i.e., \emph{Sakoe-Chiba}-band), and it's size can be controlled with function arguments.
}
\details{
\strong{Note} that the function is designed for cost matrices derived from pairs of snow profiles that have equal numbers
of layers (cf., \link{resampleSPpairs}). The function takes many matrix-like inputs, all of which need to be of the size
\verb{(profile.size x profile.size)}, i.e., square matrices of the size 'number of layers'.
}
\seealso{
\link[dtw:dtwWindowingFunctions]{dtw::dtwWindowingFunctions}
}
