% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{sass_layer}
\alias{sass_layer}
\alias{sass_layer_merge}
\title{Sass layer objects}
\usage{
sass_layer_merge(...)

sass_layer(
  defaults = "",
  declarations = "",
  rules = "",
  html_deps = NULL,
  file_attachments = character(0),
  tags = character(0)
)
}
\arguments{
\item{...}{A collection of \code{\link[=sass_layer]{sass_layer()}}s and/or objects that \code{\link[=as_sass]{as_sass()}}
understands. Arguments should be provided in reverse priority order:
defaults, declarations, and rules in later layers will take precedence over
those of previous layers. Non-layer values will be converted to layers by
calling \code{sass_layer(rules = ...)}.}

\item{defaults}{A suitable \code{\link[sass:as_sass]{sass::as_sass()}} \code{input}. Intended for declaring
variables with \code{!default}. When layers are combined, defaults are merged in
reverse order; that is, \code{sass_layer_merge(layer1, layer2)} will include
\code{layer2$defaults} before \code{layer1$defaults}.}

\item{declarations}{A suitable \code{\link[sass:as_sass]{sass::as_sass()}} \code{input}.  Intended for
function and mixin declarations, and variable declarations without
\code{!default}; not intended for actual CSS rules. These will be merged in
forward order; that is, \code{sass_layer_merge(layer1, layer2)} will include
\code{layer1$declarations} before \code{layer2$declarations}.}

\item{rules}{A suitable \code{\link[sass:as_sass]{sass::as_sass()}} \code{input}. Intended for actual CSS
rules. These will be merged in forward order; that is,
\code{sass_layer_merge(layer1, layer2)} will include \code{layer1$rules} before
\code{layer2$rules}.}

\item{html_deps}{An HTML dependency (or a list of them).}

\item{file_attachments}{A named character vector, representing file assets
that are referenced (using relative paths) from the sass in this layer. The
vector names should be a relative path, and the corresponding vector values
should be absolute paths to files or directories that exist; at render
time, each value will be copied to the relative path indicated by its name.
(For directories, the \emph{contents} of the source directory will be copied
into the destination directory; the directory itself will not be copied.)
You can also omit the name, in which case that file or directory will be
copied directly into the output directory.}

\item{tags}{A character vector with zero or more elements. Can be used to
preserve simple metadata as layers are merged.}
}
\description{
Sass layers are a way to group a set of related Sass variable definitions,
function/mixin declarations, and CSS rules into a single object. Use
\code{sass_layer()} to create these objects, and \code{sass_layer_merge()} to combine
two or more layer objects into a single layer; this ability to be merged is
the main benefit of using Sass layers versus lower-level forms of sass input.
}
\examples{
blue <- list(color = "blue !default")
red <- list(color = "red !default")
green <- list(color = "green !default")

# a sass_layer() by itself is not very useful, it just defines some
# SASS to place before (defaults) and after (declarations, rules)
core <- sass_layer(defaults = blue, rules = "body { color: $color; }")
core
sass(core)

# However, by stacking sass_layer()s, we have ability to place
# SASS both before and after some other sass (e.g., core)
# Here we place a red default _before_ the blue default and export the
# color SASS variable as a CSS variable _after_ the core
red_layer <- sass_layer(red, rules = ":root{ --color: #{$color}; }")
sass(sass_layer_merge(core, red_layer))
sass(sass_layer_merge(core, red_layer, sass_layer(green)))


# File attachment example: Create a checkboard pattern .png, then
# use it from a sass layer

tmp_png <- tempfile(fileext = ".png")
grDevices::png(filename = tmp_png, width = 20, height = 20,
  bg = "transparent", antialias = "none")
par(mar = rep_len(0,4), xaxs = "i", yaxs = "i")
plot.new()
rect(c(0,0.5), c(0,0.5), c(0.5,1), c(0.5,1), col = "#00000044", border=NA)
dev.off()

layer <- sass_layer(
  rules = ".bg-check { background-image: url(images/demo_checkboard_bg.png) }",
  file_attachments = c("images/demo_checkboard_bg.png" = tmp_png)
)

output_path <- tempfile(fileext = ".css")
sass(layer, output = output_path, write_attachments = TRUE)
}
