% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{plotClevEmp}
\alias{plotClevEmp}
\title{Empirical Cleveland's Dot Plots of the tail dependence structure.}
\usage{
plotClevEmp(sample, k, ind = "all", which = "tsic", labels = TRUE)
}
\arguments{
\item{sample}{A \code{(n times d)} matrix.}

\item{k}{An integer smaller or equal to \code{n}.}

\item{ind}{A character string among "with.singletons" and "all" (without singletons), or an integer in \eqn{\{2,...,d\}} or a list of subsets from  \eqn{\{1,...,d\}}. The default is \code{ind = "all"}.}

\item{which}{A character string among "tsic" (empirical normalized tsic plot), and "ec" (empirical normalized ec plot).}

\item{labels}{A boolean. `TRUE` the default indicates that the names of the subsets are printed. `FALSE` if only points are drawn.}
}
\value{
Draws a Cleveland dot plot of the normalized empirical tsic when \code{superset = TRUE}, the default value.

Otherwise empirical normalized ec are drawn.
}
\description{
Global comparison of the empirical tail superset importance coefficients (tsicEmp) via a Cleveland's Dot Plot.
}
\examples{

## Fix a 5-dimensional asymmetric tail dependence structure
(ds5 <- gen.ds(d = 5))

## Generate a 1000-sample of Mevlog random vectors associated with ds5
sample5 <- rMevlog(n = 1000, ds = ds5)

## Plot the empirical Cleveland dot plot (restricted to pairs)
plotClevEmp(sample5,  k = 100,  ind = 2)

}
\seealso{
\code{\link[satdad]{plotClev}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
