% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\docType{package}
\name{sazed}
\alias{sazed}
\alias{sazed-package}
\title{sazed: A package for for estimating the season length of a seasonal
time series.}
\usage{
sazed(y, iter = 0, method = "alt")
}
\arguments{
\item{y}{The input time series.}

\item{iter}{The recursion depth.}

\item{method}{The method used for breaking ties. One of \code{c("alt","diff","down")}.}
}
\value{
The season length of the input time series.
}
\description{
The sazed package provides the main function to compute season length,
sazed, which is an ensemble of many season length estimation methods,
also included in this package.

\code{sazed} estimates a time series' season length by computing 6 different estimates
and taking a majority vote.
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
sazed(y)
}
