% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\name{sazed.maj}
\alias{sazed.maj}
\title{SAZED Ensemble (Majority)}
\usage{
sazed.maj(y, iter = 0, method = "down", preprocess = T)
}
\arguments{
\item{y}{The input time series.}

\item{iter}{The recursion depth.}

\item{method}{The method used for breaking ties. One of \code{c("alt","diff","down")}.}

\item{preprocess}{If true, y is detrended and z-normalized before
computation.}
}
\value{
The season length of the input time series.
}
\description{
\code{sazed.maj} estimates a time series' season length by computing 6 different 
estimates and taking a majority vote.
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
sazed.maj(y)
}
