% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SBM_fit.R
\name{SBM_fit}
\alias{SBM_fit}
\title{R6 virtual class for SBM fit (mother class of Simple and Bipartite SBM fit)}
\description{
R6 virtual class for SBM fit (mother class of Simple and Bipartite SBM fit)

R6 virtual class for SBM fit (mother class of Simple and Bipartite SBM fit)
}
\section{Super class}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{SBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{probMemberships}}{matrix -- or list of 2 matrices for Bipartite network -- of estimated probabilities for block memberships for all nodes}

\item{\code{loglik}}{double: approximation of the log-likelihood (variational lower bound) reached}

\item{\code{ICL}}{double: value of the integrated classification log-likelihood}

\item{\code{expectation}}{expected values of connection under the currently adjusted model}

\item{\code{fitted}}{matrix of predicted value of the network}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SBM_fit$new()}}
\item \href{#method-show}{\code{SBM_fit$show()}}
\item \href{#method-setModel}{\code{SBM_fit$setModel()}}
\item \href{#method-clone}{\code{SBM_fit$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="plot">}\href{../../sbm/html/SBM.html#method-plot}{\code{sbm::SBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for SBM fit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_fit$new(data, model, dimLabels, covarList)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{the data matrix of the network}

\item{\code{model}}{character describing the type of model}

\item{\code{dimLabels}}{labels of each dimension (in row, in columns)}

\item{\code{covarList}}{optional list of matrices for covariates}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
print/show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_fit$show(type = "Fit of a Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character to tune the displayed name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setModel"></a>}}
\if{latex}{\out{\hypertarget{method-setModel}{}}}
\subsection{Method \code{setModel()}}{
method to select a specific model among the ones fitted during the optimization.
Fields of the current SBM_fit will be updated accordingly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_fit$setModel(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{integer, the index of the model to be selected (row number in storedModels)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
