% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics_Plotting.R
\name{Plot_Median_UMIs}
\alias{Plot_Median_UMIs}
\title{Plot Median UMIs per Cell per Sample}
\usage{
Plot_Median_UMIs(
  seurat_object,
  sample_col = "orig.ident",
  group_by = NULL,
  colors_use = NULL,
  plot_title = "Median UMIs/Cell per Sample",
  y_axis_label = "Median UMIs",
  x_axis_label = NULL,
  legend_title = NULL,
  x_lab_rotate = TRUE,
  color_seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{sample_col}{Specify which column in meta.data specifies sample ID (i.e. orig.ident).}

\item{group_by}{Column in meta.data slot to group results by (i.e. "Treatment").}

\item{colors_use}{List of colors or color palette to use.  Only applicable if \code{group_by} is not NULL.}

\item{plot_title}{Plot title.}

\item{y_axis_label}{Label for y axis.}

\item{x_axis_label}{Label for x axis.}

\item{legend_title}{Label for plot legend.}

\item{x_lab_rotate}{logical.  Whether to rotate the axes labels on the x-axis.  Default is FALSE.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\value{
A ggplot object
}
\description{
Plot of median UMIs per cell per sample grouped by desired meta data variable.
}
\examples{
library(Seurat)
# Create example groups
pbmc_small$sample_id <- sample(c("sample1", "sample2"), size = ncol(pbmc_small), replace = TRUE)

# Plot
Plot_Median_UMIs(seurat_object = pbmc_small, sample_col = "orig.ident",  group_by = "sample_id")

}
\concept{stats_plotting}
