% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_Plotting_Seq_10X.R
\name{Iterate_Barcode_Rank_Plot}
\alias{Iterate_Barcode_Rank_Plot}
\title{Iterative Barcode Rank Plots}
\usage{
Iterate_Barcode_Rank_Plot(
  dir_path_h5,
  multi_directory = TRUE,
  h5_filename = "raw_feature_bc_matrix.h5",
  cellranger_multi = FALSE,
  parallel = FALSE,
  num_cores = NULL,
  file_path = NULL,
  file_name = NULL,
  pt.size = 6,
  raster_dpi = c(1024, 1024),
  plateau = NULL,
  ...
)
}
\arguments{
\item{dir_path_h5}{path to parent directory (if \code{multi_directory = TRUE}) or directory containing
all h5 files (if \code{multi_directory = FALSE}).}

\item{multi_directory}{logical, whether or not all h5 files are in their own subdirectories or in a
single directory (default is TRUE; each in own subdirectory (e.g. output from Cell Ranger)).}

\item{h5_filename}{Either the file name of h5 file (if \code{multi_directory = TRUE}) or the shared
suffix (if \code{multi_directory = FALSE})}

\item{cellranger_multi}{logical, whether the outputs to be read are from Cell Ranger \code{multi} as opposed
to Cell Ranger \code{count} (default is FALSE).  Only valid if \code{multi_directory = FALSE}.}

\item{parallel}{logical, should files be read in parallel (default is FALSE).}

\item{num_cores}{Number of cores to use in parallel if \code{parallel = TRUE}.}

\item{file_path}{file path to use for saving PDF output.}

\item{file_name}{Name of PDF output file.}

\item{pt.size}{point size for plotting, default is 6.}

\item{raster_dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(1024, 1024).}

\item{plateau}{numerical values at which to add vertical line designating estimated
empty droplet plateau (default is NULL).  Must be vector equal in length to number of samples.}

\item{...}{Additional parameters passed to \code{Read10X_h5_Multi_Directory} or \code{Read10X_h5_GEO}.}
}
\value{
pdf document
}
\description{
Read data, calculate \code{DropletUtils::barcodeRanks}, create barcode rank plots, and outout single PDF output.
}
\examples{
\dontrun{
Iterate_Barcode_Rank_Plot(dir_path_h5 = "H5_PATH/", multi_directory = TRUE,
h5_filename = "raw_feature_bc_matrix", parallel = TRUE, num_cores = 12, file_path = "OUTPUT_PATH",
file_name = "Barcode_Rank_Plots")
}

}
\concept{seq_qc_plotting_basic}
