% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Add_Cell_QC_Metrics}
\alias{Add_Cell_QC_Metrics}
\title{Add Multiple Cell Quality Control Values with Single Function}
\usage{
Add_Cell_QC_Metrics(
  seurat_object,
  add_mito_ribo = TRUE,
  add_complexity = TRUE,
  add_top_pct = TRUE,
  add_MSigDB = TRUE,
  add_IEG = TRUE,
  add_cell_cycle = TRUE,
  species,
  mito_name = "percent_mito",
  ribo_name = "percent_ribo",
  mito_ribo_name = "percent_mito_ribo",
  complexity_name = "log10GenesPerUMI",
  top_pct_name = NULL,
  oxphos_name = "percent_oxphos",
  apop_name = "percent_apop",
  dna_repair_name = "percent_dna_repair",
  ieg_name = "percent_ieg",
  mito_pattern = NULL,
  ribo_pattern = NULL,
  mito_features = NULL,
  ribo_features = NULL,
  ensembl_ids = FALSE,
  num_top_genes = 50,
  assay = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{add_mito_ribo}{logical, whether to add percentage of counts belonging to mitochondrial/ribosomal
genes to object (Default is TRUE).}

\item{add_complexity}{logical, whether to add Cell Complexity to object (Default is TRUE).}

\item{add_top_pct}{logical, whether to add Top Gene Percentages to object (Default is TRUE).}

\item{add_MSigDB}{logical, whether to add percentages of counts belonging to genes from of mSigDB hallmark
gene lists: "HALLMARK_OXIDATIVE_PHOSPHORYLATION", "HALLMARK_APOPTOSIS", and "HALLMARK_DNA_REPAIR" to
object (Default is TRUE).}

\item{add_IEG}{logical, whether to add percentage of counts belonging to IEG genes to object (Default is TRUE).}

\item{add_cell_cycle}{logical, whether to addcell cycle scores and phase based on
\code{\link[Seurat]{CellCycleScoring}}.  Only applicable if \code{species = "human"}.  (Default is TRUE).}

\item{species}{Species of origin for given Seurat Object.  If mouse, human, marmoset, zebrafish, rat,
drosophila, or rhesus macaque (name or abbreviation) are provided the function will automatically
generate mito_pattern and ribo_pattern values.}

\item{mito_name}{name to use for the new meta.data column containing percent mitochondrial counts.
Default is "percent_mito".}

\item{ribo_name}{name to use for the new meta.data column containing percent ribosomal counts.
Default is "percent_ribo".}

\item{mito_ribo_name}{name to use for the new meta.data column containing percent
mitochondrial+ribosomal counts.  Default is "percent_mito_ribo".}

\item{complexity_name}{name to use for new meta data column for \code{Add_Cell_Complexity_Seurat}.
Default is "log10GenesPerUMI".}

\item{top_pct_name}{name to use for new meta data column for \code{Add_Top_Gene_Pct_Seurat}.
Default is "percent_topXX", where XX is equal to the value provided to \code{num_top_genes}.}

\item{oxphos_name}{name to use for new meta data column for percentage of MSigDB oxidative phosphorylation
counts.  Default is "percent_oxphos".}

\item{apop_name}{name to use for new meta data column for percentage of MSigDB apoptosis counts.
Default is "percent_apop".}

\item{dna_repair_name}{name to use for new meta data column for percentage of MSigDB DNA repair
counts.  Default is "percent_dna_repair"..}

\item{ieg_name}{name to use for new meta data column for percentage of IEG counts.  Default is "percent_ieg".}

\item{mito_pattern}{A regex pattern to match features against for mitochondrial genes (will set automatically if
species is mouse or human; marmoset features list saved separately).}

\item{ribo_pattern}{A regex pattern to match features against for ribosomal genes
(will set automatically if species is mouse, human, or marmoset).}

\item{mito_features}{A list of mitochondrial gene names to be used instead of using regex pattern.
Will override regex pattern if both are present (including default saved regex patterns).}

\item{ribo_features}{A list of ribosomal gene names to be used instead of using regex pattern.
Will override regex pattern if both are present (including default saved regex patterns).}

\item{ensembl_ids}{logical, whether feature names in the object are gene names or
ensembl IDs (default is FALSE; set TRUE if feature names are ensembl IDs).}

\item{num_top_genes}{An integer vector specifying the size(s) of the top set of high-abundance genes.
Used to compute the percentage of library size occupied by the most highly expressed genes in each cell.}

\item{assay}{assay to use in calculation.  Default is "RNA".  \emph{Note} This should only be changed if
storing corrected and uncorrected assays in same object (e.g. outputs of both Cell Ranger and Cell Bender).}

\item{overwrite}{Logical.  Whether to overwrite existing an meta.data column.  Default is FALSE meaning that
function will abort if column with name provided to \code{meta_col_name} is present in meta.data slot.}
}
\value{
A Seurat Object
}
\description{
Add Mito/Ribo \%, Cell Complexity (log10GenesPerUMI), Top Gene Percent with single function call
}
\examples{
\dontrun{
obj <- Add_Cell_QC_Metrics(seurat_object = obj, species = "Human")
}

}
\concept{qc_util}
