% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Extract_Top_Markers}
\alias{Extract_Top_Markers}
\title{Extract Top N Marker Genes}
\usage{
Extract_Top_Markers(
  marker_dataframe,
  num_genes = 10,
  group_by = "cluster",
  rank_by = "avg_log2FC",
  gene_column = "gene",
  gene_rownames_to_column = FALSE,
  data_frame = FALSE,
  named_vector = TRUE,
  make_unique = FALSE
)
}
\arguments{
\item{marker_dataframe}{data.frame output from \code{\link[Seurat]{FindAllMarkers}} or similar analysis.}

\item{num_genes}{number of genes per group (e.g., cluster) to include in output list.}

\item{group_by}{column name of \code{marker_dataframe} to group data by.  Default is "cluster" based on
\code{\link[Seurat]{FindAllMarkers}}.}

\item{rank_by}{column name of \code{marker_dataframe} to rank data by when selecting \code{num_genes} per \code{group_by}.
Default is "avg_log2FC" based on \code{\link[Seurat]{FindAllMarkers}}.}

\item{gene_column}{column name of \code{marker_dataframe} that contains the gene IDs.  Default is "gene"
based on \code{\link[Seurat]{FindAllMarkers}}.}

\item{gene_rownames_to_column}{logical. Whether gene IDs are stored in rownames and should be moved to
column.  Default is FALSE.}

\item{data_frame}{Logical, whether or not to return filtered data.frame of the original \code{markers_dataframe} or
to return a vector of gene IDs.  Default is FALSE.}

\item{named_vector}{Logical, whether or not to name the vector of gene names that is returned by the function.
If \code{TRUE} will name the vector using the column provided to \code{group_by}.  Default is TRUE.}

\item{make_unique}{Logical, whether an unnamed vector should return only unique values.  Default is FALSE.
Not applicable when \code{data_frame = TRUE} or \code{named_vector = TRUE}.}
}
\value{
filtered data.frame, vector, or named vector containing gene IDs.
}
\description{
Extract vector gene list (or named gene vector) from data.frame results of \code{\link[Seurat]{FindAllMarkers}}
or similar analysis.
}
\examples{
\dontrun{
top10_genes <- Extract_Top_Markers(marker_dataframe = markers_results, num_genes = 10,
group_by = "cluster", rank_by = "avg_log2FC")
}

}
\concept{marker_annotation_util}
