% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat.R
\name{SpatialDimPlot_scCustom}
\alias{SpatialDimPlot_scCustom}
\title{SpatialDimPlot with modified default settings}
\usage{
SpatialDimPlot_scCustom(
  seurat_object,
  group.by = NULL,
  images = NULL,
  colors_use = NULL,
  crop = TRUE,
  label = FALSE,
  label.size = 7,
  label.color = "white",
  label.box = TRUE,
  repel = FALSE,
  ncol = NULL,
  pt.size.factor = 1.6,
  alpha = c(1, 1),
  image.alpha = 1,
  stroke = 0.25,
  interactive = FALSE,
  combine = TRUE,
  ggplot_default_colors = FALSE,
  color_seed = 123,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{group.by}{Name of meta.data column to group the data by}

\item{images}{Name of the images to use in the plot(s)}

\item{colors_use}{color palette to use for plotting.  By default if number of levels plotted is less than
or equal to 36 it will use "polychrome" and if greater than 36 will use "varibow" with shuffle = TRUE
both from \code{DiscretePalette_scCustomize}.}

\item{crop}{Crop the plot in to focus on points plotted. Set to \code{FALSE} to show
entire background image.}

\item{label}{Whether to label the clusters}

\item{label.size}{Sets the size of the labels}

\item{label.color}{Sets the color of the label text}

\item{label.box}{Whether to put a box around the label text (geom_text vs
geom_label)}

\item{repel}{Repels the labels to prevent overlap}

\item{ncol}{Number of columns if plotting multiple plots}

\item{pt.size.factor}{Scale the size of the spots.}

\item{alpha}{Controls opacity of spots. Provide as a vector specifying the
min and max for SpatialFeaturePlot. For SpatialDimPlot, provide a single
alpha value for each plot.}

\item{image.alpha}{Adjust the opacity of the background images. Set to 0 to
remove.}

\item{stroke}{Control the width of the border around the spots}

\item{interactive}{Launch an interactive SpatialDimPlot or SpatialFeaturePlot
session, see \code{\link[Seurat]{ISpatialDimPlot}} or
\code{\link[Seurat]{ISpatialFeaturePlot}} for more details}

\item{combine}{Combine plots into a single gg object; note that if TRUE;
themeing will not work when plotting multiple features/groupings}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Creates SpatialDimPlot with some of the settings modified from their Seurat defaults (colors_use).
}
\examples{
\dontrun{
SpatialDimPlot_scCustom(seurat_object = seurat_object)
}

}
\references{
Many of the param names and descriptions are from Seurat to facilitate ease of use as
this is simply a wrapper to alter some of the default parameters \url{https://github.com/satijalab/seurat/blob/master/R/visualization.R} (License: GPL-3).
}
\concept{seurat_plotting}
