% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{seq_zeros}
\alias{seq_zeros}
\title{Create sequence with zeros}
\usage{
seq_zeros(seq_length, num_zeros = NULL)
}
\arguments{
\item{seq_length}{a seqeunce or numbers of numbers to create sequence.
Users can provide sequence (1:XX) or number of values to add in sequence (will
be used as second number in \code{seq_len}; 1:XX).}

\item{num_zeros}{number of zeros to prefix sequence, default is  (e.g, 01, 02, 03, ...)}
}
\value{
vector of numbers in sequence
}
\description{
Create sequences of numbers like \code{seq()} or \code{seq_len()} but with zeros prefixed to
keep numerical order
}
\examples{
# Using sequence
new_seq <- seq_zeros(seq_length = 1:15, num_zeros = 1)
new_seq

# Using number
new_seq <- seq_zeros(seq_length = 15, num_zeros = 1)
new_seq

# Sequence with 2 zeros
new_seq <- seq_zeros(seq_length = 1:15, num_zeros = 2)
new_seq

}
\references{
Base code from stackoverflow post:
\url{https://stackoverflow.com/a/38825614}
}
\concept{misc_util}
