% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scdeco.cop.sim.R
\name{scdeco.sim.cop}
\alias{scdeco.sim.cop}
\title{Simulating from copula model}
\usage{
scdeco.sim.cop(
  marginals,
  x,
  eta1.true,
  eta2.true,
  beta1.true,
  beta2.true,
  alpha1.true,
  alpha2.true,
  tau.true,
  w = NULL
)
}
\arguments{
\item{marginals}{provide vector of length 2 of which marginals to use}

\item{x}{covariate matrix}

\item{eta1.true}{zero-inflation parameters for marginal 1}

\item{eta2.true}{zero-inflation parameters for marginal 2}

\item{beta1.true}{mean coefficients for marginal 1}

\item{beta2.true}{mean coefficients for marginal 2}

\item{alpha1.true}{second parameter coefficients for marginal 1}

\item{alpha2.true}{second parameter coefficients for marginal 2}

\item{tau.true}{coefficients for correlation}

\item{w}{(optional) covariate matrix for zero-inflation portion}
}
\value{
matrix with values simulated from copula model
}
\description{
Simulating from copula model
}
\examples{
n <- 2500
x.use = rnorm(n)
w.use = runif(n,-1,1)
eta1.use = c(-2.2, 0.7)
eta2.use = c(-2, 0.8)
beta1.use = c(1,0.5)
beta2.use = c(1,1)
alpha1.use = 7
alpha2.use = 3
tau.use = c(-0.2, .3)

marginals.use <- c("ZINB", "ZIGA")

y.use <- scdeco.sim.cop(marginals=marginals.use, x=x.use,
                    eta1.true=eta1.use, eta2.true=eta2.use,
                    beta1.true=beta1.use, beta2.true=beta2.use,
                    alpha1.true=alpha1.use, alpha2.true=alpha2.use,
                    tau.true=tau.use, w=w.use)

y.use[1:10,]

}
