% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scMappR_and_pathway_analysis.R
\name{scMappR_and_pathway_analysis}
\alias{scMappR_and_pathway_analysis}
\title{Generate cellWeighted_Foldchange, visualize, and enrich.}
\usage{
scMappR_and_pathway_analysis(
  count_file,
  signature_matrix,
  DEG_list,
  case_grep,
  control_grep,
  rda_path = "",
  max_proportion_change = -9,
  print_plots = T,
  plot_names = "scMappR",
  theSpecies = "human",
  output_directory = "scMappR_analysis",
  sig_matrix_size = 3000,
  drop_unknown_celltype = TRUE,
  internet = TRUE,
  up_and_downregulated = FALSE,
  gene_label_size = 0.4,
  number_genes = -9,
  toSave = FALSE,
  newGprofiler = FALSE,
  path = NULL
)
}
\arguments{
\item{count_file}{Normalized RNA-seq count matrix where rows are gene symbols and columns are individuals. Either the object tself of the path of a .tsv file.}

\item{signature_matrix}{Signature matrix (recommended odds ratios) of cell-type specificity of genes. Either the object itself or a pathway to a .RData file containing an object named "wilcoxon_rank_mat_or" -- generally internal.}

\item{DEG_list}{An object with the first column as gene symbols within the bulk dataset (doesn't have to be in signature matrix), second column is the adjusted p-value, and the third the log2FC path to a .tsv file containing this info is also acceptable.}

\item{case_grep}{Tag in the column name for cases (i.e. samples representing upregulated) OR an index of cases.}

\item{control_grep}{Tag in the column name for controls (i.e. samples representing downregulated OR an index of controls).}

\item{rda_path}{If downloaded, path to where data from scMappR_data is stored.}

\item{max_proportion_change}{Maximum cell-type proportion change -- may be useful if there are many rare cell-types.}

\item{print_plots}{Whether boxplots of the estimated CT proportion for the leave-one-out method of CT deconvolution should be printed. The same name of the plots will be completed for top pathways.}

\item{plot_names}{The prefix of plot pdf files.}

\item{theSpecies}{-9 if using a pre-computed count matrix from scMappR, human, mouse, or a specied directly compatible with gProfileR. Removes Ensembl symbols if appended.}

\item{output_directory}{The name of the directory that will contain output of the analysis.}

\item{sig_matrix_size}{Number of genes in signature matrix for cell-type deconvolution.}

\item{drop_unknown_celltype}{Whether or not to remove "unknown" cell-types from the signature matrix.}

\item{internet}{Whether you have stable Wifi (T/F).}

\item{up_and_downregulated}{Whether you are additionally splitting up/downregulated genes (T/F).}

\item{gene_label_size}{The size of the gene label on the plot.}

\item{number_genes}{The number of genes to cut-off for pathway analysis (good with many DEGs).}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{newGprofiler}{Whether to use gProfileR or gprofiler2 (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
List with the following elements:
\item{cellWeighted_Foldchanges}{Cellweighted Fold-changes for all differentially expressed genes.}
\item{paths}{Enriched biological pathways for each cell-type.}
\item{TFs}{Enirched TFs for each cell-type.}
}
\description{
This function generates cell weighted Fold-changes (cellWeighted_Foldchange), visualizes them in a heatmap, and completes pathway enrichment of cellWeighted_Foldchanges and bulk gene list.
}
\details{
This function generates cellWeighted_Foldchanges for every cell-type (see deconvolute_and_contextualize), as well as the relative cell-type proportions (which will be reutrned and pushed through).
Then, it generates heatmaps of all cellWeighted_Foldchanges, cellWeighted_Foldchanges overlapping with the signature matrix, the entire signature matrix, the cell-type preference values from the signature matrix that overlap with inputted differentially expressed genes.
Then, if you have Wifi, it will complete gProfileR of the reordered cellWeighted_Foldchanges as well as a the ordered list of genes.
This function is a wrapper for deconvolute_and_contextualize and pathway_enrich_internal.
}
\examples{

data(PBMC_example)
bulk_DE_cors <- PBMC_example$bulk_DE_cors
bulk_normalized <- PBMC_example$bulk_normalized
odds_ratio_in <- PBMC_example$odds_ratio_in
case_grep <- "_female"
control_grep <- "_male"
max_proportion_change <- 10
print_plots <- FALSE
theSpecies <- "human"
toOut <- scMappR_and_pathway_analysis(bulk_normalized, odds_ratio_in, 
                                      bulk_DE_cors, case_grep = case_grep,
                                      control_grep = control_grep, rda_path = "", 
                                      max_proportion_change = 10, print_plots = TRUE, 
                                       plot_names = "tst1", theSpecies = "human", 
                                       output_directory = "tester",
                                       sig_matrix_size = 3000, up_and_downregulated = FALSE, 
                                       internet = FALSE)


}
