% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cells.R
\name{GenerateCellPositivity}
\alias{GenerateCellPositivity}
\title{Generate Cell Positivity}
\usage{
GenerateCellPositivity(
  sim_object,
  k = NA,
  xmin = NA,
  xmax = NA,
  ymin = NA,
  ymax = NA,
  sdmin = 1/2,
  sdmax = 2,
  probs = c(0, 1),
  Force = FALSE,
  density_heatmap = FALSE,
  step_size = 1,
  cores = 1,
  shift = 0,
  random = FALSE,
  overwrite = FALSE,
  use_window = FALSE
)
}
\arguments{
\item{sim_object}{A \code{SpatSimObj} object containing the simulated data.}

\item{k}{An integer specifying the number of clusters for each simulated patterns}

\item{xmin}{A numeric value specifying the minimum x value for the kernel.}

\item{xmax}{A numeric value specifying the maximum x value for the kernel.}

\item{ymin}{A numeric value specifying the minimum y value for the kernel.}

\item{ymax}{A numeric value specifying the maximum y value for the kernel.}

\item{sdmin}{A numeric value specifying the minimum standard deviation for the kernel.}

\item{sdmax}{A numeric value specifying the maximum standard deviation for the kernel.}

\item{probs}{Either a vector of c(low probability, high probability) for all cell types or data frame where each row
is the low and high probabilities for the cell type. If data frame, number of rows must equal number of cells}

\item{Force}{A logical value indicating whether to force simulation parameters to be within the simulation window limits.}

\item{density_heatmap}{A logical value indicating whether to compute a density heatmap for each cell.}

\item{step_size}{A numeric value specifying the step size for the grid of points within the window.}

\item{cores}{An integer value specifying the number of cores to use for parallel computation.}

\item{shift}{A value between 0 and 1 for how related a second or more cell type is to the first}

\item{random}{whether or not to randomly generate kernels for cells 2 or more, uf TRUE, shift is not used}

\item{overwrite}{boolean whether to overwrite existing cell kernels and assignments if present}

\item{use_window}{boolean whether to use the simulation window to set x and y limits}
}
\value{
Returns the original \code{scSpatialSIM} object with additional generated data added to each cell object.
}
\description{
Generate the probability of a cell being positive given a set of simulation parameters for each file in a SpatSimObj.
}
\details{
The function generates the probability of a cell being positive given a set of simulation parameters f
or each file in a \code{scSpatialSIM} object. It creates a kernel parameter list for \code{k} clusters
in each simulated pattern and computes the probability of each point in the grid of points within the
window for each cell. The function also computes a density heatmap for each cell if \code{density_heatmap} is set to \code{TRUE}.
}
