% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotFrame}
\alias{plotFrame}
\title{Plot a frame of the video.}
\usage{
plotFrame(scalpelOutput, frame, videoType = "processed",
  shrinkLargest = FALSE, shrinkCutoff = NULL, title = NULL,
  col = grDevices::grey(seq(0, 1, length = 256)), addToPlot = FALSE,
  Y = NULL)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep0}}, \code{\link{scalpelStep1}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{frame}{The frame to plot.}

\item{videoType}{Specify whether to plot the processed data from Step 0 (default; \code{videoType="processed"}) or raw data (\code{videoType="raw"}).
This is ignored if \code{Y} is provided.}

\item{shrinkLargest}{Logical value indicating whether the values above \code{shrinkCutoff} should be shrunk when plotting. Shrinking these values
allows us to better visualize the areas with the largest fluorescence.}

\item{shrinkCutoff}{The value above which pixel values will be shrunk. By default, this will be chosen as
\code{scalpelOutput$lowThreshold} if \code{class(scalpelOutput)=="scalpelStep0"} or \code{min(scalpelOutput$thresholdVec)} otherwise.}

\item{title}{Label for the title. By default, it is the frame number.}

\item{col}{Vector of colors to use, which by default is grayscale.}

\item{addToPlot}{Logical value indicating whether to add to the current plot.}

\item{Y}{An object of class \code{scalpelY}, which results from running the \code{\link{getY}} function. When not specified, \code{Y}
is automatically read in, but specifying \code{Y} is recommended when the user
would like to call this function many times, as this avoids reading the video into memory repeatedly.}
}
\value{
None
}
\description{
We plot a specified frame of the raw video that we began with in Step 0 of SCALPEL,
or the processed video that results from Step 0 of SCALPEL.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#simplest example with default parameters:
plotFrame(scalpelOutput = scalpelOutput, frame = 100)

#example with optional parameters:
#plot raw data instead of processed
plotFrame(scalpelOutput = scalpelOutput, frame = 100, videoType = "raw")

#same plot but if you have video data read in already
#using 'getY' function, you can provide it
rawY = getY(scalpelOutput = scalpelOutput, videoType = "raw")
plotFrame(scalpelOutput = scalpelOutput, frame = 100, Y = rawY)
}
}
\seealso{
\code{\link{scalpelStep0}}, \code{\link{scalpel}}
}

