% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotBrightest}
\alias{plotBrightest}
\title{Plot the most active frames for a given neuron.}
\usage{
plotBrightest(scalpelOutput, AfilterIndex, videoType = "processed",
  neuronsToOutline = "all", brightIndex = 1, shrinkLargest = FALSE,
  shrinkCutoff = NULL, title = NULL, Y = NULL)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}} or \code{\link{scalpelStep3}}.}

\item{AfilterIndex}{Scalar giving the neuron for which to plot the brightest frames. The index refers to which column
of \code{scalpelOutput$Afilter} is of interest.}

\item{videoType}{Specify whether to plot the processed data from Step 0 (default; \code{videoType="processed"}) or raw data (\code{videoType="raw"}).
This is ignored if \code{Y} is provided.}

\item{neuronsToOutline}{Specify whether to plot outlines of all neurons (default; \code{neuronsToOutline="all"}),
only the outline for \code{neuron} (\code{neuronsToOutline="main"}), outlines of only the neurons kept
using a previous call to \code{\link{reviewNeurons}} or \code{\link{reviewNeuronsInteractive}} (\code{neuronsToOutline="kept"}),
 or none (\code{neuronsToOutline="none"}).}

\item{brightIndex}{Scalar giving which of the ordered brightest frames to plot. The default is 1, i.e., the brightest frame.}

\item{shrinkLargest}{Logical value indicating whether the values above \code{shrinkCutoff} should be shrunk when plotting. Shrinking these values
allows us to better visualize the areas with the largest fluorescence.}

\item{shrinkCutoff}{The value above which pixel values will be shrunk. By default, this will be chosen as
\code{min(scalpelOutput$thresholdVec)}.}

\item{title}{Label for the title. The default is frame number.}

\item{Y}{An object of class \code{scalpelY}, which results from running the \code{\link{getY}} function. When not specified, \code{Y}
is automatically read in, but specifying \code{Y} is recommended when the user
would like to call this function many times, as this avoids reading the video into memory repeatedly.}
}
\value{
None
}
\description{
For a given neuron, we plot the frames with the highest estimated fluorescence, which
results from fitting the sparse group lasso in Step 3 of SCALPEL.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#simplest example with default parameters:
plotBrightest(scalpelOutput = scalpelOutput, AfilterIndex = 2)

#example with optional parameters:
#only outline neuron corresponding to frame, plot 5th brightest with raw data
plotBrightest(scalpelOutput = scalpelOutput, AfilterIndex = 2, videoType = "raw",
             neuronsToOutline = "main", brightIndex = 5)

#same plot but if you have video data read in already
#using 'getY' function, you can provide it
rawY = getY(scalpelOutput = scalpelOutput, videoType = "raw")
plotBrightest(scalpelOutput = scalpelOutput, AfilterIndex = 2, Y = rawY,
             neuronsToOutline = "main", brightIndex = 5)
}
}
\seealso{
\code{\link{scalpel}}, \code{\link{scalpelStep3}}
}
