% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_stepFunctions.R
\name{scalpelStep1}
\alias{scalpelStep1}
\title{Perform Step 1 of SCALPEL.}
\usage{
scalpelStep1(
  step0Output,
  minSize = 25,
  maxSize = 500,
  maxWidth = 30,
  maxHeight = 30,
  thresholdVec = NULL
)
}
\arguments{
\item{step0Output}{An object of class \code{scalpel} or \code{scalpelStep0}, which result from running the
\code{\link{scalpel}} or \code{\link{scalpelStep0}} functions, respectively.}

\item{minSize, maxSize}{The minimum and maximum size, respectively, for a preliminary dictionary element with default values
of 25 and 500, respectively.}

\item{maxWidth, maxHeight}{The maximum width and height, respectively, for a preliminary dictionary element with default values of 30.}

\item{thresholdVec}{Optional advanced user argument: A vector with the desired thresholds to use for image segmentation. If not specified, the default is to
use the negative of the minimum of the processed Y data (i.e., \code{step0Output$highThreshold}), the negative of the 0.1\% quantile of the processed Y data
(i.e., \code{step0Output$lowThreshold}), and the mean of these. These automatically chosen thresholds can also be updated using \code{\link{updateThreshold}}.}
}
\value{
An object of class \code{scalpelStep1}, which can be summarized using \code{\link{summary}}, used to run SCALPEL Step 2 using \code{\link{scalpelStep2}},
or can be used with the plotting function \code{\link{plotCandidateFrame}}.
\itemize{
\item{\code{Azero}: }{A matrix containing the preliminary dictionary elements, where the ith column of \code{Azero}
is a vector of 1's and 0's, indicating whether each pixel is contained in the ith preliminary dictionary element.}
\item{\code{AzeroFrames}: }{A vector whose ith element gives the video frame from which the preliminary dictionary element
in the ith column of \code{Azero} was derived.}
\item{\code{AzeroThreshold}: }{A vector whose ith element gives the threshold used to obtain the preliminary dictionary element
in the ith column of \code{Azero}.}
\item{\code{pixelsUse}: }{A vector with the pixels (i.e., indices of the rows of \code{Azero}) that are contained in at
least one preliminary dictionary element.}
\item{\code{version}: }{A 5-digit unique identifier for the output folder name that is automatically generated in this step.}
\item{Other elements: }{As specified by the user or returned from a previous step.}
}
}
\description{
This step involves constructing a spatial component dictionary. We apply a simple image segmentation
procedure to each frame of the video in order to derive a dictionary of preliminary dictionary elements.
Ideally, this dictionary is a superset of the true spatial components.
}
\details{
Several files containing data from this step and a summary of the step are saved in
"outputFolder/Step1_version" where \code{version} is a 5-digit unique identifier that is automatically generated.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpelStep0" function

#run Step 1 of SCALPEL
Step1Out = scalpelStep1(step0Output = Step0Out)
summary(Step1Out)
}
}
\seealso{
The entire SCALPEL pipeline can be implemented using the \code{\link{scalpel}} function. The
other steps in the pipeline can be run using the \code{\link{scalpelStep0}}, \code{\link{scalpelStep2}}, \code{\link{scalpelStep3}} functions.
Results from this step can be summarized using \code{\link{summary}}, loaded at a later time using \code{\link{getScalpelStep1}}, and plotted
using \code{\link{plotCandidateFrame}}.
}
