% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSC.R
\name{readSC}
\alias{readSC}
\alias{readSC.excel}
\title{Read single-case data from files}
\usage{
readSC(
  filename = NULL,
  data = NULL,
  sep = ",",
  dec = ".",
  sort.labels = FALSE,
  cvar = "case",
  pvar = "phase",
  dvar = "values",
  mvar = "mt",
  phase.names = NULL,
  type = "csv",
  ...
)

readSC.excel(...)
}
\arguments{
\item{filename}{A character string defining the file to be imported (e.g.
\code{"SC_Anita.csv"}. If filename is left empty a dialog box for choosing
will be opened.}

\item{data}{A data frame. As an alternative to \code{filname} a dataframe could be 
directly provided.}

\item{sep}{The field separator string. Values within rows have to be
separated by this string. Default is \code{sep = ","}.}

\item{dec}{The string used for decimal points in the file. Must be a single
character. Default is \code{dec = "."}}

\item{sort.labels}{If set TRUE, the resulting list is sorted by label names
(alphabetically increasing).}

\item{cvar}{Sets the variable name of the "case" variable. Deafults to \code{"case"}.}

\item{pvar}{Sets the variable name of the "phase" variable. Deafults to \code{"phase"}.}

\item{dvar}{Sets the variable name of the "values" variable. Deafults to \code{"values"}.}

\item{mvar}{Sets the variable name of the "mt" variable. Deafults to \code{"mt"}.}

\item{phase.names}{A character vector with phase names. Deafults to the phase names provided 
in the phase variable.}

\item{type}{Format of the file to be imported. Either "csv" or "excel" is
possible.}

\item{\dots}{Further arguments passed to the \code{\link{read.table}}
command.}
}
\value{
Returns a single-case data frame. See \code{\link{scdf}} to learn
about the format of these data frames.
}
\description{
Use the \code{readSC} function to import single-case data from structured
.csv or the \code{readSC.excel} function for importing excel files.
}
\examples{

## Read SC-data from a file named "study1.csv" in your working directory
# study1 <- readSC("study1.csv")

## Read SC-data from a .csv-file with semicolon as field and comma as decimal separator
# study2 <- readSC("study2.csv", sep = ";", dec = ",")

## writeSc and readSC
filename <- file.path(tempdir(),"test.csv")
writeSC(exampleA1B1A2B2_zvt, filename)
dat <- readSC(filename, cvar = "case", pvar = "part", dvar = "zvt", mvar = "day")
res1 <- describeSC(exampleA1B1A2B2_zvt)$descriptives
res2 <- describeSC(dat)$descriptives
identical(res1,res2)

}
\seealso{
\code{\link{read.table}}, \code{\link{writeSC}}, \code{\link{scdf}}, \code{\link{readRDS}}
}
\author{
Juergen Wilbert
}
\keyword{manip}
