% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R, R/export.sc_desc.R,
%   R/export.sc_hplm.R, R/export.sc_nap.R, R/export.sc_overlap.R,
%   R/export.sc_pem.R, R/export.sc_plm.R, R/export.sc_power.R,
%   R/export.sc_smd.R, R/export.sc_tauu.R, R/export.sc_trend.R, R/export.scdf.R
\name{export}
\alias{export}
\alias{export.sc_desc}
\alias{export.sc_hplm}
\alias{export.sc_nap}
\alias{export.sc_overlap}
\alias{export.sc_pem}
\alias{export.sc_plm}
\alias{export.sc_power}
\alias{export.sc_smd}
\alias{export.sc_tauu}
\alias{export.sc_trend}
\alias{export.scdf}
\title{Export scan objects to html or latex}
\usage{
export(object, ...)

\method{export}{sc_desc}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  flip = FALSE,
  ...
)

\method{export}{sc_hplm}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  nice = TRUE,
  ...
)

\method{export}{sc_nap}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  ...
)

\method{export}{sc_overlap}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  flip = FALSE,
  ...
)

\method{export}{sc_pem}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  ...
)

\method{export}{sc_plm}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  nice = TRUE,
  ...
)

\method{export}{sc_power}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  ...
)

\method{export}{sc_smd}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  select = c("Case", `Mean A` = "mA", `Mean B` = "mB", `SD A` = "sdA", `SD B` = "sdB",
    `SD Cohen` = "sd cohen", `SD Hedges` = "sd hedges", "Glass' delta", "Hedges' g",
    "Hedges' g correction", "Hedges' g durlak correction", "Cohen's d"),
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  flip = FALSE,
  ...
)

\method{export}{sc_tauu}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  select = "auto",
  kable_styling_options = list(),
  kable_options = list(),
  meta = TRUE,
  ...
)

\method{export}{sc_trend}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  ...
)

\method{export}{scdf}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  cols,
  ...
)
}
\arguments{
\item{object}{An scdf or an object exported from a scan function.}

\item{...}{Further Arguments passed to internal functions.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{kable_styling_options}{list with arguments passed to the kable_styling
function.}

\item{kable_options}{list with arguments passed to the kable function.}

\item{flip}{If TRUE, some objects are exported with rows and columns flipped.}

\item{round}{Integer passed to the digits argument internally used to round
values.}

\item{nice}{If set TRUE (default) output values are rounded and optimized for
publication tables.}

\item{select}{Character vector with name of variables to be included. When
the vector is named, variables are renamed appropriately.}

\item{meta}{If TRUE, the results of the meta analysis will be exported. If
FALSE, each single-case is exported.}

\item{cols}{Defines which columns are included when exporting an scdf. It is
either a vector of variable names or the string "main" will select the
central variables.}
}
\value{
Returns or displays a specially formatted html (or latex) file.
}
\description{
This function is in an experimental status. Export creates html files of
tables or displays them directly in the viewer pane of rstudio. When applied
in rmarkdown/quarto, tables can also be created for pdf/latex output.
}
