% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{simulate_zip_scanstatistic}
\alias{simulate_zip_scanstatistic}
\title{Simulate a single expectation-based ZIP-EM scan statistic.}
\usage{
simulate_zip_scanstatistic(table, zones, ...)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{location, duration, p,
mu}. The column \code{mu} contains the Poisson expected values, the column 
\code{p} contains the excess zero probabilities.}

\item{zones}{A \code{set} of zones, each zone itself being a \code{set}
containing locations. Locations should be encoded as integers.}

\item{...}{Arguments passed to \code{\link{zip_calculations}}.}
}
\value{
A scalar; the expectation-based ZIP-EM scan statistic for the 
   simulated data.
}
\description{
Simulate zero-inflated -distributed data according to the supplied parameters 
and calculate the value of the expectation-based Poisson scan statistic.
}
\keyword{internal}

