% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{coords_to_knn}
\alias{coords_to_knn}
\title{Get the k nearest neighbors for each location, given its coordinates.}
\usage{
coords_to_knn(x, k = min(10, nrow(x)), method = "euclidean", p = 2)
}
\arguments{
\item{x}{a numeric matrix, data frame or \code{"dist"} object.}

\item{k}{The number of nearest neighbors, counting the location itself.}

\item{method}{the distance measure to be used. This must be one of
    \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
    \code{"canberra"}, \code{"binary"} or \code{"minkowski"}.
    Any unambiguous substring can be given.}

\item{p}{The power of the Minkowski distance.}
}
\value{
An integer matrix of the \eqn{k} nearest neighbors for each location. 
   Each row corresponds to a location, with the first element of each row 
   being the location itself. Locations are encoded as integers.
}
\description{
Get the k nearest neighbors for each location, including the location itself.
This function calls \code{\link[stats]{dist}}, so the options for the 
distance measure used is the same as for that one. Distances are calculated 
between rows.
}
\examples{
x <- matrix(c(0, 0,
              1, 0,
              2, 1,
              0, 4,
              1, 3),
            ncol = 2, byrow = TRUE)
plot(x)
coords_to_knn(x)
}
