% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fss_subset_score.R
\name{subset_aggregation_FN_NF}
\alias{subset_aggregation_FN_NF}
\title{Compute the most likely cluster using the FN/NF Subset Aggregation algorithm.}
\usage{
subset_aggregation_FN_NF(args, score_fun = poisson_score,
  priority_fun = poisson_priority, algorithm = "FN")
}
\arguments{
\item{args}{A list of arrays:
   \describe{
     \item{counts}{Required. An array of counts (integer or numeric). First
                   dimension is time, ordered from most recent to most 
                   distant. Second dimension indicates locations, which will 
                   be enumerated from 1 and up. Third dimension indicates 
                   data streams, which will be enumerated from 1 and up.}
     \item{baselines}{Required. A matrix of expected counts. Dimensions are 
                      as for \code{counts}.}
     \item{penalties}{Optional. A matrix of penalty terms. Dimensions are as
                      for \code{counts}.}
     \item{...}{Optional. More matrices with distribution parameters.
                Dimensions are as for \code{counts}.}
}}

\item{score_fun}{A function taking matrix arguments, all of the
same dimension, and returning a matrix or vector of that dimension. 
Suitable alternatives are \code{\link{poisson_score}}, 
\code{\link{gaussian_score}}.}

\item{priority_fun}{A function taking matrix arguments, all of the
same dimension, and returning a matrix or vector of that dimension. 
Suitable alternatives are \code{\link{poisson_priority}}, 
\code{\link{gaussian_priority}}.}

\item{algorithm}{Either "FN" or "NF":
\describe{
  \item{FN}{Fast optimization over subsets of locations and naive 
            optimization over subsets of streams. Can be used if the 
            number of data streams is small.}
  \item{NF}{Fast optimization over subsets of streams and naive 
            optimization over subsets of locations. Can be used if the 
            number of locations is small.}
}}
}
\value{
A list with 4 elements:
   \describe{
     \item{score}{A scalar; the score of the MLC.}
     \item{duration}{An integer; the duration of the MLC, i.e. how many time 
                     periods from the present into the past the MLC 
                     stretches.}
     \item{locations}{An integer vector; the locations contained in the MLC.}
     \item{streams}{An integer vector; the data streams contained in the 
                    MLC.}
  }
}
\description{
Compute the most likely cluster (MLC) with the Subset Aggregation method by
Neill et al. (2013), either through fast optimization over subsets of 
locations and naive optimization over subsets of streams (FN), or through
naive optimization over subsets of locations and fast optimization over 
subsets of streams (NF).
}
\references{
Neill, Daniel B., Edward McFowland, and Huanian Zheng (2013). \emph{Fast 
   subset scan for multivariate event detection}. Statistics in Medicine 
   32 (13), pp. 2185-2208.
}
\keyword{internal}
