% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scattermore.R
\name{geom_scattermost}
\alias{geom_scattermost}
\title{geom_scattermost}
\usage{
geom_scattermost(xy, color = "black", interpolate = FALSE,
  pointsize = 0, pixels = c(512, 512))
}
\arguments{
\item{xy}{2-column object with data, as in \code{\link[=scattermore]{scattermore()}}.}

\item{color}{Color vector (or a single color).}

\item{interpolate}{Default FALSE, passed to \code{\link[grid:rasterGrob]{grid::rasterGrob()}}.}

\item{pointsize}{Radius of rasterized point. Use \code{0} for single pixels (fastest).}

\item{pixels}{Vector with X and Y resolution of the raster, default \code{c(512,512)}.}
}
\description{
Totally non-ggplotish version of \code{\link[=geom_scattermore]{geom_scattermore()}}, but faster. It avoids
most of the ggplot processing by bypassing the largest portion of data
around any ggplot functionality, leaving only enough data to set up axes and
limits correctly. If you need to break speed records, use this.
}
\examples{
library(ggplot2)
library(scattermore)
d <- data.frame(x=rnorm(1000000), y=rnorm(1000000))
x_rng <- range(d$x)
ggplot() +
  geom_scattermost(cbind(d$x,d$y),
                   color=heat.colors(100, alpha=.01)
                         [1+99*(d$x-x_rng[1])/diff(x_rng)],
                   pointsize=2.5,
                   pixels=c(1000,1000),
                   interpolate=TRUE)
}
