% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.get_gaps}
\alias{bursts.get_gaps}
\title{Get the gaps between bursts.}
\usage{
bursts.get_gaps(bursts)
}
\arguments{
\item{bursts}{The list of segments}
}
\value{
A vector of N+1 gaps for N bursts times
}
\description{
Extract vector of gaps from the bursts. This is done using the start_time attribute, which is mostly hidden in the data. (The gaps at the ends may have length 0)
}
\examples{
infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")
gaps <- bursts.get_gaps(bursts)

head(gaps)
}
