% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_clustering_stats}
\alias{get_clustering_stats}
\title{Get clustering statistics}
\usage{
get_clustering_stats(distances, clustering)
}
\arguments{
\item{distances}{a \code{\link[distances]{distances}} object describing the distances
between the data points in \code{clustering}.}

\item{clustering}{a \code{\link{scclust}} object containing a non-empty clustering.}
}
\value{
Returns a list of class \code{clustering_stats} containing the statistics.
}
\description{
\code{get_clustering_stats} calculates statistics of a clustering.
}
\details{
The function reports the following measures:

\tabular{ll}{
  \code{num_data_points} \tab total number of data points \cr
  \code{num_assigned} \tab number of points assigned to a cluster \cr
  \code{num_clusters} \tab number of clusters \cr
  \code{min_cluster_size} \tab size of the smallest cluster \cr
  \code{max_cluster_size} \tab size of the largest cluster \cr
  \code{avg_cluster_size} \tab  average cluster size \cr
  \code{sum_dists} \tab sum of all within-cluster distances \cr
  \code{min_dist} \tab smallest within-cluster distance \cr
  \code{max_dist} \tab largest within-cluster distance \cr
  \code{avg_min_dist} \tab average of the clusters' smallest distances \cr
  \code{avg_max_dist} \tab average of the clusters' largest distances \cr
  \code{avg_dist_weighted} \tab average of the clusters' average distances
     weighed by cluster size \cr
  \code{avg_dist_unweighted} \tab average of the clusters' average distances
     (unweighed)  \cr
}

Let \eqn{d(i,j)}{d(i,j)} denote the distance between data points \eqn{i}{i}
and \eqn{j}{j}. Let \eqn{c}{c} be a cluster containing the indices of points
assigned to the cluster. Let \deqn{D(c) = \{d(i,j): i,j \in c \wedge i>j\}}{D(c) = { d(i,j) : i,j in c and i > j }}
be a function returning all within-cluster distances in \eqn{c}{c}. Let
\eqn{C}{C} be a set containing all clusters.

\code{sum_dists} is defined as:
\deqn{\sum_{c\in C} sum(D(c))}{\sum_[c in C] sum(D(c))}

\code{min_dist} is defined as:
\deqn{\min_{c\in C} \min(D(c))}{min_[c in C] min(D(c))}

\code{max_dist} is defined as:
\deqn{\max_{c\in C} \max(D(c))}{max_[c in C] max(D(c))}

\code{avg_min_dist} is defined as:
\deqn{\sum_{c\in C} \frac{\min(D(c))}{|C|}}{\sum_[c in C] min(D(c)) / count(C)}

\code{avg_max_dist} is defined as:
\deqn{\sum_{c\in C} \frac{\max(D(c))}{|C|}}{\sum_[c in C] max(D(c)) / count(C)}

Let:
\deqn{AD(c) = \frac{sum(D(c))}{|D(c)|}}{AD(c) = sum(D(c)) / count(D(c))}
be the average within-cluster distance in cluster \eqn{c}{c}.

\code{avg_dist_weighted} is defined as:
\deqn{\sum_{c\in C} \frac{|c| AD(c)}{num_assigned}}{\sum_[c in C] count(c) * AD(c) / num_assigned}
where \eqn{num_assigned}{num_assigned} is the number of assigned data
points (see above).

\code{avg_dist_unweighted} is defined as:
\deqn{\sum_{c\in C} \frac{AD(c)}{|C|}}{\sum_[c in C] AD(c) / count(C)}
}
\examples{
my_data_points <- data.frame(x = c(0.1, 0.2, 0.3, 0.4, 0.5,
                                   0.6, 0.7, 0.8, 0.9, 1.0),
                             y = c(10, 9, 8, 7, 6,
                                   10, 9, 8, 7, 6))

my_distances <- distances(my_data_points)

my_scclust <- scclust(c("A", "A", "B", "C", "B",
                        "C", "C", "A", "B", "B"))

get_clustering_stats(my_distances, my_scclust)

# >                     Value
# > num_data_points     10.0000000
# > num_assigned        10.0000000
# > num_clusters         3.0000000
# > min_cluster_size     3.0000000
# > max_cluster_size     4.0000000
# > avg_cluster_size     3.3333333
# > sum_dists           18.2013097
# > min_dist             0.5000000
# > max_dist             3.0066593
# > avg_min_dist         0.8366584
# > avg_max_dist         2.4148611
# > avg_dist_weighted    1.5575594
# > avg_dist_unweighted  1.5847484

}
