% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing-functions.R
\name{graph_SCD}
\alias{graph_SCD}
\title{Graph Single Case Design Data}
\usage{
graph_SCD(
  case,
  phase,
  session,
  outcome,
  design,
  treatment_name = NULL,
  model_fit = NULL,
  data = NULL
)
}
\arguments{
\item{case}{vector of case indicators or name of a character or factor vector within \code{data} indicating unique cases.}

\item{phase}{vector of treatment indicators or name of a character or factor vector within \code{data} indicating unique treatment phases.}

\item{session}{vector of measurement occasions or name of numeric vector within \code{data} of measurement times.}

\item{outcome}{vector of outcome data or name of numeric vector of outcome data within \code{data}.}

\item{design}{Character string to specify whether data comes from a treatment reversal, "TR", or multiple baseline, "MB", design.}

\item{treatment_name}{(Optional) character string corresponding to the name of the treatment phase.}

\item{model_fit}{(Optional) lme fitted model that adds predicted values to graph}

\item{data}{(Optional) dataset to use for analysis. Must be a \code{data.frame}.}
}
\value{
A ggplot graph
}
\description{
Graphs single case design data for treatment reversal and multiple baseline designs.
}
\note{
If treatment_name is left null it will choose the second level of the phase variable to be the treatment phase.
}
\examples{
data(Anglesea)
graph_SCD(case=case, phase=condition, 
          session=session, outcome=outcome, 
          design="TR", treatment_name = "treatment", 
          data=Anglesea)
          
data(BartonArwood)
graph_SCD(case=case, phase=condition, 
          session=session, outcome=outcome, 
          design="MB", treatment_name = "B",  
          data=BartonArwood)

}
