% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_BCSMD.R
\name{batch_calc_BCSMD}
\alias{batch_calc_BCSMD}
\title{A convenience function for calculating multiple design-comparable
  effect sizes from a dataset that compiles data from multiple single-case
  design studies}
\usage{
batch_calc_BCSMD(
  data,
  design,
  grouping,
  case,
  phase,
  session,
  outcome,
  cluster = NULL,
  series = NULL,
  center = 0,
  round_session = TRUE,
  treatment_name = NULL,
  FE_base = 0,
  RE_base = 0,
  RE_base_2 = NULL,
  FE_trt = 0,
  RE_trt = NULL,
  RE_trt_2 = NULL,
  corStruct = "AR1",
  varStruct = "hom",
  A = NULL,
  B = NULL,
  D = NULL,
  cover = 95,
  bound = 35,
  symmetric = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame containing SCD data for which design-comparable
effect sizes will be calculated.}

\item{design}{Character string to specify whether data comes from a treatment
reversal (\code{"TR"}), multiple baseline across participants
(\code{"MBP"}), replicated multiple baseline across behaviors
(\code{"RMBB"}), or clustered multiple baseline across participants (\code{"CMB"}).}

\item{grouping}{A variable name or list of (unquoted) variable names that
uniquely identify each study.}

\item{case}{A variable name (unquoted) that identifies unique cases within
each \code{grouping} variable.}

\item{phase}{A variable name (unquoted) that identifies unique treatment
phases.}

\item{session}{A variable name (unquoted) that contains the measurement times
for each data series.}

\item{outcome}{A variable name (unquoted) that contains the outcome
measurements for each data series.}

\item{cluster}{(Optional) variable name (unquoted) that identifies the unique
clusters of cases for \code{CMB} designs.}

\item{series}{(Optional) variable name (unquoted) that identifies the unique
data series for \code{RMBB} designs.}

\item{center}{Numeric value for the centering value for session. Default is 0.}

\item{round_session}{Logical indicating whether to round \code{session} to the nearest integer. Defaults to \code{TRUE}.}

\item{treatment_name}{(Optional) character string corresponding to the name
of the treatment phase.}

\item{FE_base}{Vector of integers specifying which fixed effect terms to
include in the baseline phase. Setting \code{FE_base = 0} includes only a
level. Setting \code{FE_base = c(0,1)} includes a level and a linear time
trend.}

\item{RE_base}{Vector of integers specifying which random effect terms to
include in the baseline phase. Setting \code{RE_base = 0} includes only
levels (i.e., random intercepts). Setting \code{RE_base = c(0,1)} includes
random levels and random linear trends.}

\item{RE_base_2}{Vector of integers specifying which random effect terms to
include in the baseline phase for the cluster level in clustered multiple
baseline design across participants or for the case level in replicated
multiple baseline across behaviors. Setting \code{RE_base_2 = 0} includes
only levels (i.e., random intercepts). Setting \code{RE_base_2 = c(0,1)}
includes random levels and random linear trends.}

\item{FE_trt}{Vector of integers specifying which fixed effect terms to
include in the treatment phase. Setting \code{FE_trt = 0} includes only a
change in level. Setting \code{FE_trt = c(0,1)} includes a change in level
and a treatment-by-linear time trend.}

\item{RE_trt}{Vector of integers specifying which random effect terms to
include in the treatment phase. Setting \code{RE_trt = 0} includes only
random changes in level. Setting \code{RE_trt = c(0,1)} includes random
changes in level and random treatment-by-linear time trends.}

\item{RE_trt_2}{Vector of integers specifying which random effect terms to
include in the treatment phase for the cluster level in clustered multiple
baseline design across participants or for the case level in replicated
multiple baseline across behaviors. Setting \code{RE_trt_2 = 0} includes
only random changes in level. Setting \code{RE_trt_2 = c(0,1)} includes
random changes in level and random treatment-by-linear time trends.}

\item{corStruct}{(Optional) character string indicating the correlation
structure of session-level errors. Options are \code{"AR1"} (default),
\code{"MA1"}, or \code{"IID"}.}

\item{varStruct}{(Optional) character string indicating the
heteroscedasticity structure of session-level errors. Options are
\code{"hom"} (default) or \code{"het"}, which allows for the session-level
error variances to differ by phase.}

\item{A}{The time point immediately before the start of treatment in the
hypothetical between-group design.}

\item{B}{The time point at which outcomes are measured in the hypothetical
between-group design.}

\item{D}{Numerical indicating the treatment duration across cases. Note that
\code{B = A + D} and it is not allowed to specify both \code{B} and
\code{D}.}

\item{cover}{Confidence level.}

\item{bound}{Numerical tolerance for non-centrality parameter in
\code{\link[stats]{qt}}.}

\item{symmetric}{If \code{TRUE} (the default), use a symmetric confidence
interval. If \code{FALSE}, use a non-central t approximation to obtain an
asymmetric confidence interval.}

\item{...}{further arguments.}
}
\value{
A data frame containing the design-comparable effect size estimate,
  standard error, confidence interval, and other information, for each unique
  category of \code{grouping} variable(s).
}
\description{
Calculates standardized mean difference effect sizes for a data
  set including one or multiple single-case design studies using the same
  design (treatment reversal, multiple baseline/probe across participants,
  replicated multiple baseline across behaviors, or clustered multiple
  baseline across participants).
}
\examples{
data(Thiemann2001)
data(Thiemann2004)
datThiemann <- rbind(Thiemann2001, Thiemann2004)

# Change-in-levels model with a fixed treatment effect
batch_calc_BCSMD(data = datThiemann,
                 grouping = Study_ID,
                 design = "RMBB",
                 case = case, series = series, phase = treatment,
                 session = time, outcome = outcome,
                 FE_base = 0, RE_base = 0,
                 RE_base_2 = 0, FE_trt = 0)

# Models with linear time trends in baseline and treatment phase,
# random baseline slope at series level, fixed treatment effects
batch_calc_BCSMD(data = datThiemann,
                 grouping = Study_ID,
                 design = "RMBB",
                 case = case, series = series, phase = treatment,
                 session = time, outcome = outcome,
                 FE_base = c(0,1), RE_base = c(0,1),
                 RE_base_2 = 0, FE_trt = c(0,1))

}
