#' Basic Single Case Design
#'
#' This is the data for the Basic Single Case Design Example presented in
#' Figure 14 of the What Works Clearinghouse Procedures and Standards Handbook,
#' Version 5.0
#'
#' @format ## `basic_scd`
#' A data frame with 21 rows and 3 columns:
#' \describe{
#'   \item{phase}{Study phase}
#'   \item{time}{Time of data collection}
#'   \item{socbehavs}{Social behaviors score}
#' }
#' @source <https://ies.ed.gov/ncee/WWC/Docs/referenceresources/Final_WWC-HandbookVer5_0-0-508.pdf>
"basic_scd"


#' Reversal/withdrawal Design Example
#'
#' This is the data for the Reversal/Withdrawal Design Example presented in
#' Figure 17 of the What Works Clearinghouse Procedures and Standards Handbook,
#' Version 5.0
#'
#' @format ## `reversal_withdrawal`
#' A data frame with 21 rows and 3 columns:
#' \describe{
#'   \item{phase}{Study phase}
#'   \item{time}{Time of data collection}
#'   \item{extbehavs}{Externalizing behaviors score}
#' }
#' @source <https://ies.ed.gov/ncee/WWC/Docs/referenceresources/Final_WWC-HandbookVer5_0-0-508.pdf>
"reversal_withdrawal"


#' Fictional Single Case Design Efficacy of CBT Example
#'
#' This is the data set used for the clinical case example in Maric & van der Werf
#' (2020).
#'
#' @references Maric, M., & van der Werff, V. (2020). Single-Case Experimental
#' Designs in Clinical Intervention Research. In R. van de Schoot & M. Miocevic
#' (Eds.), Small Sample Size Solutions: A Guide for Applied Researchers and
#' Practitioners (1st ed., pp. 10). Routledge.
#' <doi:10.4324/9780429273872-9>
#'
#' @format ## `efficacy_of_CBT`
#' A data frame with 10 rows and 4 columns:
#' \describe{
#'   \item{phase}{Study phase}
#'   \item{time}{Time of data collection}
#'   \item{Anxious}{Outcome measure}
#'   \item{CATS_N}{Outcome measure}
#' }
#' @source <doi:10.4324/9780429273872-9>
"efficacy_of_CBT"

#' Sleeping Pills and Dizziness Example
#'
#' This is the data set used for the example in Onghena (2020).
#'
#' @references Onghena, P. (2020). One by one: The design and analysis of
#' replicated randomized single-case experiments. In R. van de Schoot & M. Miocevic
#' (Eds.), Small sample size solutions: A guide for applied researchers and
#' practitioners (1st ed., pp. 15). Routledge. <doi:10.4324/9780429273872-8>
#'
#' @format ## `sleeping_pills`
#' A data frame with 14 rows and 3 columns:
#' \describe{
#'   \item{day}{day of study}
#'   \item{treatment}{E, Experimental; C, Control}
#'   \item{sever_compl}{Severity of complaints}
#' }
#' @source <doi:10.4324/9780429273872-8>
"sleeping_pills"


