% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetJCol}
\alias{GetJCol}
\title{GetJCol}
\usage{
GetJCol(fname, ncol)
}
\arguments{
\item{fname}{String with the file name that contains the binary data.}

\item{ncol}{The number of the column to be returned, in R-numbering (from 1)}
}
\value{
A numeric vector with the values of elements in the requested column
}
\description{
Returns (as a R numeric vector) the requested column number from the matrix contained in a jmatrix binary file
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
Rf[,3]
vf<-GetJCol(tmpfile1,3)
vf
}
