% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataIO.R
\name{SCELoom}
\alias{SCELoom}
\title{Data Format Conversion between SingleCellExperiment and loom.}
\usage{
SCELoom(
  from = c("SingleCellExperiment", "loom"),
  to = c("loom", "SingleCellExperiment"),
  sce = NULL,
  loom.file = NULL,
  ...
)
}
\arguments{
\item{from}{The source data format to convert, chosen from SingleCellExperiment and AnnData.
Default: SingleCellExperiment.}

\item{to}{The target data format to convert, chosen from AnnData and SingleCellExperiment.
Default: loom.}

\item{sce}{The SingleCellExperiment object to convert. Default: NULL.}

\item{loom.file}{File used to save or contains loom results. Default: NULL.}

\item{...}{Parameters for \code{sceasy::convertFormat} and \code{sceasy::convertFormat}.}
}
\value{
NULL or SingleCellExperiment.
}
\description{
Data Format Conversion between SingleCellExperiment and loom.
}
\examples{
\dontrun{
# convert from loom to SingleCellExperiment, need users to provide the loom file
sce.obj <- SCELoom(
  from = "loom", to = "SingleCellExperiment",
  loom.file = "path/to/loom"
)
# convert from SingleCellExperiment to loom, need users to provide the loom file
SCELoom(
  from = "SingleCellExperiment", to = "loom", sce = sce.obj,
  loom.file = "path/to/loom"
)
}
}
