% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_fcts.R
\name{get_url_request_result}
\alias{get_url_request_result}
\title{Send a request and get results.}
\usage{
get_url_request_result(
  request,
  useragent = NULL,
  ssl_verifypeer = TRUE,
  binary = FALSE
)
}
\arguments{
\item{request}{A \code{sched:Request} object.}

\item{useragent}{The user agent, as a character value. Example: "myapp ;
my.name@my.addr"}

\item{ssl_verifypeer}{Set to \code{FALSE} if you want to disable SSL
verification for https sites. \code{TRUE} by default.}

\item{binary}{Set to TRUE if the content to be retrieved is binary.}
}
\value{
The request result, as a character value.
}
\description{
Send the request described by a Request instance, using the provided user
agent, and return the results.
}
\examples{
# Retrieve the content of a web page
u <- sched::URL$new('https://httpbin.org/get')
content <- sched::get_url_request_result(sched::Request$new(u))

}
