% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{hsl_to_hsv}
\alias{hsl_to_hsv}
\title{Convert HSL to HSV}
\usage{
hsl_to_hsv(hsl)
}
\arguments{
\item{hsl}{A dataframe or matrix with H, S and L colour channels located in the columns 1 to 3, respectively. H in degrees in [0, 360], S and L in [0, 1]}
}
\value{
A \code{tibble} of H, S and V colour channels. Hue is constant between colour spaces, while saturation differs.
}
\description{
Convert HSL to HSV
}
\examples{
H <- sample(x = 0:360, size = 10, replace = TRUE)
S <- runif(n = 10)
L <- runif(n = 10)
hsl_to_hsv(data.frame(h = H, s = S, l = L))
}
