% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sclr.R
\name{sclr}
\alias{sclr}
\title{Fits the scaled logit model}
\usage{
sclr(formula, data = NULL, ci_lvl = 0.95, tol = 10^(-7),
  n_iter = NULL, max_tol_it = 10^4, n_conv = 3,
  conventional_names = FALSE)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the
model to be fitted.}

\item{data}{a data frame.}

\item{ci_lvl}{Confidence interval level for the parameter estimates.}

\item{tol}{Tolerance. Used when \code{n_iter} is \code{NULL}.}

\item{n_iter}{Number of Newton-Raphson iterations. \code{tol} is ignored when
this is not \code{NULL}.}

\item{max_tol_it}{Maximum tolerated iterations. If it fails to converge
within this number of iterations, will return with an error.}

\item{n_conv}{Number of times the algorithm has to converge (to work around
local maxima).}

\item{conventional_names}{If \code{TRUE}, estimated parameter names will be
(Baseline), (Intercept) and the column names in the model matrix. Otherwise
- lambda, beta_0 and beta_ prefix in front of column names in the model
matrix.}
}
\value{
An object of class \code{sclr}. This is a list with the following
  elements:

  \item{parameters}{Maximum likelihood estimates of the parameter values.}

  \item{covariance_mat}{The variance-covariance matrix of the parameter
  estimates.}

  \item{n_converge}{The number of Newton-Raphson iterations (including
  resets) that were required for convergence.}

  \item{x}{Model matrix derived from \code{formula} and \code{data}.}

  \item{y}{Response matrix derived from \code{formula} and \code{data}.}
  
  \item{call}{The original call to \code{sclr}.}

  \item{model}{Model frame object derived from \code{formula} and 
  \code{data}.}

  \item{terms}{Terms object derived from model frame.}
  
  \item{ci}{Confidence intervals of the parameter estimates.}
  
  \item{log_likelihood}{Value of log-likelihood calculated at the ML
  estimates of parameters.} 

  Methods supported: \code{\link[=print.sclr]{print}},
  \code{\link[=vcov.sclr]{vcov}}, \code{\link[=coef.sclr]{coef}},
  \code{\link[=model.frame.sclr]{model.frame}},
  \code{\link[=model.matrix.sclr]{model.matrix}},
  \code{\link[=summary.sclr]{summary}}, \code{\link[=predict.sclr]{predict}},
  \code{\link[=tidy.sclr]{tidy}} (\code{\link{broom}} package).
}
\description{
Used to fit the scaled logit model from Dunning (2006).
}
\details{
The model is of the form \deqn{P(Y = 1) = \lambda(1 - logit^{-1}(\beta_0 +
\beta_1X_1 + \beta_2X_2 + ... + \beta_kX_k))} Where \eqn{Y} is the binary
outcome indicator, (eg. 1 - infected, 0 - not infected). \eqn{X} - covariate.
\eqn{k} - number of covariates. Computing engine behind the fitting is
\code{\link{sclr_fit}}.
}
\examples{
library(sclr)
fit1 <- sclr(status ~ logHI, one_titre_data)
summary(fit1)
}
\references{
Dunning AJ (2006). "A model for immunological correlates of
  protection." Statistics in Medicine, 25(9), 1485-1497.
  \url{https://doi.org/10.1002/sim.2282}.
}
