% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{summarizeData}
\alias{summarizeData}
\title{Summarization of data}
\usage{
summarizeData(data, fun = mean, group.by = NULL, ignore = NULL, ...)
}
\arguments{
\item{data}{A matrix or data frame to be summarized.}

\item{fun}{Function to be used in the summarization. It can be any function that, taking as first argument a numeric vector, otuputs a numeric value. Typical examples are \code{\link{mean}}, \code{\link{median}}, \code{\link{min}}, \code{\link{max}} or \code{\link{sd}}.}

\item{group.by}{A vector of either column names or column indices according to which the data will be grouped to be summarized.}

\item{ignore}{A vector of either column names or column indices of the columns that have to be removed from the output.}

\item{...}{Additional parameters to the summarization function (\code{fun}). For example, \code{na.rm=TRUE} to indicate that the missing values should be ignored.}
}
\value{
A data frame where, for each combination of the values in the columns indicated by \code{group.by}, each column (except those in \code{ignore}) contains the summarization of the values in the original matrix that have that combination of values.
#'
}
\description{
This is a simple function to apply a summarization function to a matrix or data frame.
}
\examples{
data(data_blum_2015)
# Group by size and radius. Get the mean and variance of only the last two
# columns.
summarizeData (data.blum.2015, group.by=c("Radius","Size"), ignore=3:8,
               fun=mean, na.rm=TRUE)
summarizeData (data.blum.2015, group.by=c("Radius","Size"), ignore=3:8,
               fun=sd, na.rm=TRUE)
}
\seealso{
\code{\link{filterData}}, \code{\link{writeTabular}} and the vignette \code{vignette(topic="Data_loading_and_manipulation",
package="scmamp")}
}

