% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\docType{class}
\name{ScoperClones-class}
\alias{ScoperClones-class}
\alias{ScoperClones}
\alias{print,ScoperClones-method}
\alias{ScoperClones-method}
\alias{summary,ScoperClones-method}
\alias{plot,ScoperClones,missing-method}
\alias{as.data.frame,ScoperClones-method}
\title{S4 class containing clonal assignments and summary data}
\usage{
\S4method{print}{ScoperClones}(x)

\S4method{summary}{ScoperClones}(object)

\S4method{plot}{ScoperClones,missing}(x, y, ...)

\S4method{as.data.frame}{ScoperClones}(x)
}
\arguments{
\item{x}{ScoperClones object}

\item{object}{ScoperClones object}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotCloneSummary}.}
}
\description{
\code{ScoperClones} stores output from \link{identicalClones}, \link{hierarchicalClones} and
\link{spectralClones} functions.
}
\section{Slots}{

\describe{
\item{\code{db}}{\code{data.frame} of repertoire data including with clonal identifiers in 
the column specified during processing.}

\item{\code{vjl_groups}}{\code{data.frame} of clonal summary, including sequence count, V gene, 
J gene, junction length, and clone counts.}

\item{\code{inter_intra}}{\code{data.frame} containing minimum inter (between) and maximum intra 
(within) clonal distances.}

\item{\code{eff_threshold}}{effective cut-off separating the inter (between) and intra (within) clonal 
distances.}
}}

\seealso{
\link{identicalClones}, \link{hierarchicalClones} and \link{spectralClones}
}
