% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_ply}
\alias{woebin_ply}
\title{Application of Binning}
\usage{
woebin_ply(dt, bins)
}
\arguments{
\item{dt}{A data frame.}

\item{bins}{Binning information generated by \code{woebin}.}
}
\value{
Binning information
}
\description{
\code{woebin_ply} converts original input data into woe values based on the binning information generated by \code{woebin}.
}
\examples{
# load germancredit data
data(germancredit)

dt <- germancredit[, c("creditability", "credit.amount", "purpose")]

# binning
bins <- woebin(dt, y = "creditability")

# converting original value to woe
dt_woe <- woebin_ply(dt, bins=bins)

\dontrun{
# binning for germancredit dataset
bins_all <- woebin(germancredit, y="creditability")

# converting the values of germancredit into woe
germancredit_woe <- woebin_ply(germancredit, bins_all)
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_plot}}
}
