% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf.R
\name{perf_eva}
\alias{perf_eva}
\title{KS, ROC, Lift, PR}
\usage{
perf_eva(label, pred, title = "train", groupnum = 20, type = c("ks",
  "roc"), show_plot = TRUE, seed = 186)
}
\arguments{
\item{label}{Label values, such as 0s and 1s, 0 represent for good and 1 for bad.}

\item{pred}{Predicted probability values.}

\item{title}{Title of plot, default "train".}

\item{groupnum}{The group numbers when calculating bad probability, default 20.}

\item{type}{Types of performance plot, such as "ks", "lift", "roc", "pr". Default c("ks", "roc").}

\item{show_plot}{Logical value, default TRUE. It means whether to show plot.}

\item{seed}{An integer. The specify seed is used for random sorting data, default: 186.}
}
\value{
ks, roc, lift, pr
}
\description{
\code{perf_eva} provides performance evaluations, such as kolmogorov-smirnow(ks), ROC, lift and precision-recall curves, based on provided label and predicted probability values.
}
\examples{
\dontrun{
library(data.table)
library(scorecard)

# Traditional Credit Scoring Using Logistic Regression
# load germancredit data
data("germancredit")

# rename creditability as y
dt <- data.table(germancredit)[, `:=`(
  y = ifelse(creditability == "bad", 1, 0),
  creditability = NULL
)]

# woe binning ------
bins <- woebin(dt, "y")
dt_woe <- woebin_ply(dt, bins)

# glm ------
m1 <- glm( y ~ ., family = "binomial", data = dt_woe)
# summary(m1)

# Select a formula-based model by AIC
m_step <- step(m1, direction="both", trace=FALSE)
m2 <- eval(m_step$call)
# summary(m2)

# predicted proability
dt_pred <- predict(m2, type='response', dt_woe)

# performance ------
# Example I # only ks & auc values
perf_eva(dt_woe$y, dt_pred, show_plot=FALSE)

# Example II # ks & roc plot
perf_eva(dt_woe$y, dt_pred)

# Example III # ks, lift, roc & pr plot
perf_eva(dt_woe$y, dt_pred, type = c("ks","lift","roc","pr"))
}
}
\seealso{
\code{\link{perf_psi}}
}
