% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif.R
\name{vif}
\alias{vif}
\title{Variance Inflation Factors}
\usage{
vif(model, merge_coef = FALSE)
}
\arguments{
\item{model}{A model object.}

\item{merge_coef}{Logical, whether to merge with coefficients of model summary matrix. Defaults to FALSE.}
}
\value{
A data frame with columns for variable and gvif, or additional columns for df and gvif^(1/(2*df)) if provided model uses factor variable.
}
\description{
\code{vif} calculates variance-inflation and generalized variance-inflation factors for linear, generalized linear.
}
\examples{
data(germancredit)

# Example I
fit1 = glm(creditability~ age.in.years + credit.amount +
  present.residence.since, family = binomial(), data = germancredit)
vif(fit1)
vif(fit1, merge_coef=TRUE)

# Example II
fit2 = glm(creditability~ status.of.existing.checking.account +
  credit.history + credit.amount, family = binomial(), data = germancredit)
vif(fit2)
vif(fit2, merge_coef=TRUE)


}
\seealso{
\url{https://cran.r-project.org/package=car}
}
