% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_hot.R
\name{var_scale}
\alias{var_scale}
\title{Variable Scaling}
\usage{
var_scale(dt, var_skip = NULL, type = "standard", ...)
}
\arguments{
\item{dt}{a data frame or vector}

\item{var_skip}{Name of variables that will skip for scaling Defaults to NULL.}

\item{type}{type of scaling method, including standard or minmax.}

\item{...}{Additional parameters.}
}
\description{
scaling variables using standardization or normalization
}
\examples{
data("germancredit")

# standardization
dts1 = var_scale(germancredit, type = 'standard')

# normalization/minmax
dts2 = var_scale(germancredit, type = 'minmax')
dts2 = var_scale(germancredit, type = 'minmax', new_range = c(-1, 1))

}
