% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fn_target}
\alias{fn_target}
\title{Redefines target value}
\usage{
fn_target(base, target, event)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable, to be passed as string}

\item{event}{the event class, to be passed as string}
}
\value{
The function returns a dataframe after changing the target classes to 0 or 1.
}
\description{
The function redefines the "binary" target variable to be used for modelling. It takes the variable or field name of the target and the event class. It changes the target field name to "Target", changes the events into 1 and non-events as 0 and places the target column at the end of the dataframe before returning it as output.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)

data2 <- fn_target(base = data,target = "Y",event = 1)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
