% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaltape.R
\name{evaltape}
\alias{evaltape}
\alias{evaltape_wsum}
\title{Evaluate a CppAD Tape Many Times}
\usage{
evaltape(tape, xmat, pmat, xcentres = NA * xmat, approxorder = 10)

evaltape_wsum(
  tape,
  xmat,
  pmat,
  w = NULL,
  xcentres = NA * xmat,
  approxorder = 10
)
}
\arguments{
\item{tape}{An \code{\link{ADFun}} object (i.e. a tape of a function).}

\item{xmat}{A matrix of (multivariate) independent variables where each represents a single independent variable vector. Or a single independent variable vector that is used for all rows of \code{pmat}.}

\item{pmat}{A matrix of dynamic parameters where each row specifies a new set of values for the dynamic parameters of \code{tape}. Or a single vector of dynamic parameters to use for all rows of \code{xmat}.}

\item{xcentres}{A matrix of approximation for Taylor approximation centres for \code{xmat}. Use values of \code{NA} for rows that do not require Taylor approximation.}

\item{approxorder}{Order of Taylor approximation}

\item{w}{Weights to apply to each row of \code{xmat} for computing the weighted sum. If \code{NULL} then each row is given a weight of \code{1}.}
}
\value{
A matrix, each row corresponding to the evaluation of the same row in \code{xmat}, \code{pmat} and \code{xcentres}.
}
\description{
Evaluates a tape exactly or approximately for an array of provided variable values and dynamic parameter values.
The function \code{evaltape_wsum()} computes the column-wise weighted sum of the result.
}
\details{
Approximation is via Taylor approximation of the independent variable around the approximation centre provided in \code{xcentres}.
}
\examples{
u <- rep(1/3, 3)
tapes <- buildsmdtape("sim", "sqrt", "sph", "ppi",
              ytape = u,
              usertheta = ppi_paramvec(p = 3),
              bdryw = "minsq", acut = 0.01,
              verbose = FALSE
              )
evaltape(tapes$lltape, u, rppi_egmodel(1)$theta)
evaltape(tapes$smdtape, rppi_egmodel(1)$theta, u)
evaltape(tapes$lltape, rbind(c(0, 0, 1), c(0,0,1)), 
         rppi_egmodel(1)$theta, 
         xcentres = rbind(c(0.0005, 0.0005, 0.999), NA))
}
\seealso{
Other tape evaluators: 
\code{\link{quadratictape_parts}()},
\code{\link{smvalues}()},
\code{\link{testquadratic}()}
}
\concept{tape evaluators}
